@echo off

REM This is a part of the Microsoft Foundation Classes C++ library.
REM Copyright (C) 1992-1995 Microsoft Corporation
REM All rights reserved.
REM
REM This source code is only intended as a supplement to the
REM Microsoft Foundation Classes Reference and related
REM electronic documentation provided with the library.
REM See these sources for detailed information regarding the
REM

echo.
echo Microsoft Foundation Classes -- Sample Applications (batch build)
echo.
echo This MS-DOS Batch file will build most of the Windows/MFC sample
echo applications.  Use of the batch file will save time and
echo disk space if you are interested in seeing all of the
echo working samples as you learn the Microsoft Foundation Classes.
echo If you are modifying a sample or using it as a basis for
echo your own application, then the use of the Visual Workbench
echo is recommended.
echo.
echo.

set __DEBUG=1
if "%1"=="DEBUG" goto doit
if "%1"=="debug" goto doit

set __DEBUG=0

if "%1"=="RETAIL" goto doit
if "%1"=="retail" goto doit

if "%1"=="CLEAN" goto doit_clean
if "%1"=="clean" goto doit_clean

echo Please specify DEBUG or RETAIL or CLEAN on the command line.
echo.
echo     DEBUG will build executables with symbolic information,
echo         diagnostics, and no optimizations (large and slow).
echo     RETAIL will build ship quality executables that
echo         are fully optimized (small and fast).
echo     CLEAN will remove all compiler generated files (object
echo         files, executables, etc.)  Use this to switch between
echo         DEBUG and RETAIL.
echo.

goto end

:doit
shift

echo.
echo NOTE: Since this builds all the sample programs it could
echo take a little while.  Type Ctrl-C now if you wish
echo to build them later.  You can stop the build at
echo any time by typing Ctrl-C (several times) and
echo answer 'Y' to terminate.
echo.
pause
goto doit_build

:doit_clean

@echo on
if exist STDAFX??.PCH erase STDAFX??.PCH
if exist STDAFX??.OBJ erase STDAFX??.OBJ
if exist STDDLL??.PCH erase STDDLL??.PCH
if exist STDDLL??.OBJ erase STDDLL??.OBJ

:doit_build
@echo on

cd GENERAL\CTRLBARS
echo General samples
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\CTRLTEST
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DIBLOOK
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DOCKTOOL
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DYNAMENU
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\HELLO
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\HELLOAPP
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MAPIPAD
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MDI
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MULTIPAD
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\PROPDLG
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\TRACKER
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\VIEWEX
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch

cd ..\..\OLE\CALCDRIV
echo OLE samples
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DRAWCLI
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\HIERSVR
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\INPROC
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\IPDRIVE
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MFCCALC
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\OCLIENT
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\SUPERPAD
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch

cd ..\..\DATABASE\CATALOG
echo Database samples
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DYNABIND
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\STDREG
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch

cd ..\..\ADVANCED\CHATSRVR
echo Advanced samples
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\CHATTER
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\COLLECT
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\CHKBOOK
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\CUBE
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DLLHUSK
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\DLLTRACE
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\FIRE
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MFCUCASE
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MTGDI
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MTMDI
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MTRECALC
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\OLDBARS
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\SPEAKN
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch

cd ..\..\UTILITY\GUIDGEN
echo Utility samples
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\MAKEHM
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\TEMPLDEF
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..\TRACER
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch

cd ..\..\TUTORIAL\AUTODRIV
echo Tutorials
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch

if not exist ..\SCRIBBLE\STEP7\makefile goto contain
if "%1"=="CLEAN" erase ..\SCRIBBLE\STDAFX??.PCH
if "%1"=="CLEAN" erase ..\SCRIBBLE\STDAFX??.OBJ
cd ..\SCRIBBLE\STEP7
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..

:contain
if not exist ..\CONTAIN\STEP2\makefile goto autoclik
if "%1"=="CLEAN" erase ..\CONTAIN\STDAFX??.PCH
if "%1"=="CLEAN" erase ..\CONTAIN\STDAFX??.OBJ
cd ..\CONTAIN\STEP2
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..

:autoclik
if not exist ..\AUTOCLIK\STEP3\makefile goto enroll
if "%1"=="CLEAN" erase ..\AUTOCLIK\STDAFX??.PCH
if "%1"=="CLEAN" erase ..\AUTOCLIK\STDAFX??.OBJ
cd ..\AUTOCLIK\STEP3
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..

:enroll
if not exist ..\ENROLL\STEP4\makefile goto updir
if "%1"=="CLEAN" erase ..\ENROLL\STDAFX??.PCH
if "%1"=="CLEAN" erase ..\ENROLL\STDAFX??.OBJ
cd ..\ENROLL\STEP4
nmake /nologo "DEBUG=%__DEBUG%" %1
del *.pch
cd ..

:updir
cd ..\..

:end
set __DEBUG=
